/////////////////////////////////////////////////////////////
// CINEMA SDK : LISTS        															 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D V8      												 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4DNODEDATA_H
#define __C4DNODEDATA_H

#include "c4d_basedata.h"

class GeListNode;
class HyperFile;
class AliasTrans;
class BaseDocument;
class String;
class Description;
class DescID;
class GeData;
class BaseContainer;
class BaseBitmap;
struct NODEPLUGIN;
struct BranchInfo;

class NodeData : public BaseData
{
	protected:
		GeListNode *private_link;
	public:
		GeListNode *Get(void) const { return private_link; }

		virtual Bool Init(GeListNode *node);
		virtual void Free(GeListNode *node);
		virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		virtual Bool Write(GeListNode *node, HyperFile *hf);
		virtual Bool Message(GeListNode *node, LONG type, void *data);
		virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		virtual void GetBubbleHelp(GeListNode *node, String &str);
		virtual BaseDocument* GetDocument(GeListNode *node);
		virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max);

		virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		virtual Bool GetDEnabling(GeListNode *node, const DescID &id,GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
};

typedef NodeData *DataAllocator(void);

void FillNodePlugin(NODEPLUGIN *np, LONG info, DataAllocator *g, BaseBitmap *icon, LONG disklevel, void *emulation=NULL);
Bool RegisterNodePlugin(LONG id, const String &str, LONG info, DataAllocator *g, BaseBitmap *icon, LONG disklevel, LONG *fallback);

#endif
